/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.biome_painter;

import com.moulberry.axiom.BiomeDataManager;
import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.brush_shapes.BrushShape;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.BrushWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.pather.async.AsyncToolPathProvider;
import com.moulberry.axiom.pather.async.AsyncToolPather;
import com.moulberry.axiom.pather.async.AsyncToolPatherUnique;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.IntWrapper;
import com.moulberry.axiom.world_modification.BiomeBuffer;
import com.moulberry.axiom.world_modification.BlockOrBiomeBuffer;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.moulberry.axiom.world_modification.HistoryEntry;
import imgui.ImGui;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import org.joml.Matrix4f;

public class BiomePainterTool
implements Tool {
    private final ChunkedBooleanRegion chunkedBooleanRegion = new ChunkedBooleanRegion();
    private boolean usingTool = false;
    private AsyncToolPathProvider pathProvider = null;
    private final BrushWidget brushWidget = new BrushWidget();
    private boolean biomeOverlay = true;
    private boolean fillVertically = false;
    private static final int[] selectedBiome = new int[]{0};
    private static final List<BiomeWithIndex> filteredBiomes = new ArrayList<BiomeWithIndex>();
    private static String biomeFilter = "";

    @Override
    public void reset() {
        this.usingTool = false;
        this.chunkedBooleanRegion.clear();
        if (this.pathProvider != null) {
            this.pathProvider.close();
            this.pathProvider = null;
        }
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case RIGHT_MOUSE: {
                this.reset();
                this.usingTool = true;
                this.pathProvider = new AsyncToolPathProvider(this.createToolPather(this.brushWidget.getBrushShape()));
                return UserAction.ActionResult.USED_STOP;
            }
            case ESCAPE: {
                if (!this.usingTool) break;
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        if (!this.usingTool) {
            RayCaster.RaycastResult result = Tool.raycastBlock();
            if (result == null) {
                Selection.render(camera, time, matrices, projection, 7);
                return;
            }
            Selection.render(camera, time, matrices, projection, 4);
            this.brushWidget.renderPreview(camera, class_243.method_24954((class_2382)result.getBlockPos()), matrices, projection, time, 3);
        } else if (Tool.cancelUsing()) {
            this.reset();
        } else if (!Tool.isMouseDown(1)) {
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                this.reset();
                return;
            }
            BiomeDataManager biomeDataManager = BiomeDataManager.get();
            if (biomeDataManager == null) {
                this.reset();
                return;
            }
            List<BiomeDataManager.BiomeDataEntry> biomes = biomeDataManager.biomes();
            if (selectedBiome[0] < 0 || selectedBiome[0] >= biomes.size()) {
                this.reset();
                return;
            }
            class_5321<class_1959> biome = biomes.get(selectedBiome[0]).key();
            BiomeBuffer setOperation = new BiomeBuffer();
            BiomeBuffer previousBiomesForUndo = new BiomeBuffer();
            IntWrapper count = new IntWrapper();
            if (this.fillVertically) {
                PositionSet alreadyChecked = new PositionSet();
                this.chunkedBooleanRegion.forEach((x, y, z) -> {
                    if (alreadyChecked.add(x, 0, z)) {
                        class_2818 chunk = (class_2818)level.method_8402(x >> 2, z >> 2, class_2806.field_12803, false);
                        if (chunk == null) {
                            return;
                        }
                        int sectionCount = chunk.method_32890();
                        int minSection = chunk.method_32891();
                        for (int i = 0; i < sectionCount; ++i) {
                            class_2826 section = chunk.method_38259(i);
                            for (int ly = 0; ly < 4; ++ly) {
                                class_6880.class_6883 reference;
                                class_5321 oldBiomeKey;
                                class_6880 oldBiome = section.method_38293(x & 3, ly, z & 3);
                                if (!(oldBiome instanceof class_6880.class_6883) || (oldBiomeKey = (reference = (class_6880.class_6883)oldBiome).method_40237()) == biome) continue;
                                int by = (i + minSection << 2) + ly;
                                setOperation.set(x, by, z, biome);
                                previousBiomesForUndo.set(x, by, z, (class_5321<class_1959>)oldBiomeKey);
                                ++count.value;
                            }
                        }
                    }
                });
            } else {
                this.chunkedBooleanRegion.forEach((x, y, z) -> {
                    class_6880.class_6883 reference;
                    class_5321 oldBiomeKey;
                    class_2818 chunk = (class_2818)level.method_8402(x >> 2, z >> 2, class_2806.field_12803, false);
                    if (chunk == null) {
                        return;
                    }
                    int index = level.method_31603(y >> 2);
                    if (index < 0 || index >= level.method_32890()) {
                        return;
                    }
                    class_2826 section = chunk.method_38259(index);
                    class_6880 oldBiome = section.method_38293(x & 3, y & 3, z & 3);
                    if (oldBiome instanceof class_6880.class_6883 && (oldBiomeKey = (reference = (class_6880.class_6883)oldBiome).method_40237()) != biome) {
                        setOperation.set(x, y, z, biome);
                        previousBiomesForUndo.set(x, y, z, (class_5321<class_1959>)oldBiomeKey);
                        ++count.value;
                    }
                });
            }
            class_2338 center = this.chunkedBooleanRegion.getCenter();
            center = new class_2338(center.method_10263() * 4 + 2, center.method_10264() * 4 + 2, center.method_10260() * 4 + 2);
            class_2487 sourceInfo = Tool.getSourceInfo(this);
            String countString = NumberFormat.getInstance().format((long)count.value * 4L * 4L * 4L);
            String historyDescription = AxiomI18n.get("axiom.history_description.biome_painted", countString);
            Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(setOperation, previousBiomesForUndo, center, historyDescription, 0), sourceInfo);
            this.reset();
        } else {
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                return;
            }
            Selection.render(camera, time, matrices, projection, 4);
            this.pathProvider.update();
            this.chunkedBooleanRegion.setScale(4.0f, 4.0f, 4.0f);
            this.chunkedBooleanRegion.render(camera, class_243.field_1353, matrices, projection, time, 1);
        }
    }

    private AsyncToolPather createToolPather(BrushShape brushShape) {
        class_638 level = class_310.method_1551().field_1687;
        MaskElement maskElement = MaskManager.getDestMask();
        MaskContext maskContext = new MaskContext((class_1937)level);
        return new AsyncToolPatherUnique(brushShape, (x, y, z) -> {
            if (maskElement.test(maskContext.reset(), x, y, z)) {
                this.chunkedBooleanRegion.add(x >> 2, y >> 2, z >> 2);
            }
        });
    }

    public boolean shouldRenderBiomeOverlay() {
        return this.biomeOverlay;
    }

    @Override
    public void displayImguiOptions() {
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.brush"));
        this.brushWidget.displayImgui();
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.biome_painter"));
        BiomePainterTool.renderBiomeDropdown();
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.biome_painter.fill_vertically"), this.fillVertically)) {
            boolean bl = this.fillVertically = !this.fillVertically;
        }
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.biome_painter.visualize_biomes"), this.biomeOverlay)) {
            this.biomeOverlay = !this.biomeOverlay;
        }
    }

    private static void renderBiomeDropdown() {
        List<BiomeDataManager.BiomeDataEntry> biomes;
        BiomeDataManager biomeDataManager = BiomeDataManager.get();
        if (biomeDataManager == null) {
            ImGui.text(AxiomI18n.get("axiom.widget.error_biome_registry"));
            return;
        }
        if (biomeDataManager.justRefreshed()) {
            filteredBiomes.clear();
            biomeFilter = "";
        }
        if ((biomes = biomeDataManager.biomes()).isEmpty()) {
            ImGui.text(AxiomI18n.get("axiom.widget.error_biome_registry"));
            return;
        }
        if (selectedBiome[0] >= biomes.size()) {
            BiomePainterTool.selectedBiome[0] = 0;
        }
        String currentBiome = biomes.get(selectedBiome[0]).prettyName();
        if (ImGui.beginCombo("##Biomes", biomeFilter.isEmpty() ? currentBiome : biomeFilter)) {
            ImGui.captureKeyboardFromApp();
            String biomeFilterOld = biomeFilter;
            biomeFilter = ImGuiHelper.modifyFromInput(biomeFilter);
            boolean enterPressed = ImGui.getIO().getKeysDown(257);
            if (biomeFilter.isEmpty()) {
                for (int i = 0; i < biomes.size(); ++i) {
                    boolean selected;
                    ImGui.pushID(i);
                    boolean bl = selected = i == selectedBiome[0];
                    if (ImGui.selectable(biomes.get(i).prettyName(), selected) && !selected) {
                        BiomePainterTool.selectedBiome[0] = i;
                    }
                    if (enterPressed && ImGui.isItemFocused()) {
                        BiomePainterTool.selectedBiome[0] = i;
                        ImGui.popID();
                        ImGui.closeCurrentPopup();
                        ImGui.endCombo();
                        return;
                    }
                    if (selected) {
                        ImGui.setItemDefaultFocus();
                    }
                    ImGui.popID();
                }
                if (enterPressed) {
                    BiomePainterTool.selectedBiome[0] = 0;
                    ImGui.closeCurrentPopup();
                }
            } else {
                if (!biomeFilter.equals(biomeFilterOld)) {
                    String filterLower = biomeFilter.toLowerCase(Locale.ROOT);
                    filteredBiomes.clear();
                    for (int i = 0; i < biomes.size(); ++i) {
                        String biome = biomes.get(i).prettyName();
                        if (!biome.toLowerCase(Locale.ROOT).contains(filterLower)) continue;
                        filteredBiomes.add(new BiomeWithIndex(biome, i));
                    }
                }
                for (int i = 0; i < filteredBiomes.size(); ++i) {
                    boolean selected;
                    ImGui.pushID(i);
                    BiomeWithIndex biomeWithIndex = filteredBiomes.get(i);
                    boolean bl = selected = biomeWithIndex.index == selectedBiome[0];
                    if (ImGui.selectable(biomeWithIndex.prettyName, selected) && !selected) {
                        BiomePainterTool.selectedBiome[0] = biomeWithIndex.index;
                    }
                    if (enterPressed && ImGui.isItemFocused()) {
                        BiomePainterTool.selectedBiome[0] = biomeWithIndex.index;
                        ImGui.popID();
                        ImGui.closeCurrentPopup();
                        ImGui.endCombo();
                        return;
                    }
                    if (selected) {
                        ImGui.setItemDefaultFocus();
                    }
                    ImGui.popID();
                }
                if (enterPressed && filteredBiomes.size() > 0) {
                    BiomePainterTool.selectedBiome[0] = BiomePainterTool.filteredBiomes.get((int)0).index;
                    ImGui.closeCurrentPopup();
                }
            }
            ImGui.endCombo();
        } else {
            biomeFilter = "";
        }
    }

    @Override
    public String listenForEsc() {
        if (!this.usingTool) {
            return null;
        }
        return AxiomI18n.get("axiom.widget.cancel");
    }

    @Override
    public boolean initiateAdjustment() {
        return this.brushWidget.initiateAdjustment();
    }

    @Override
    public class_241 renderAdjustment(float mouseX, float mouseY, class_241 mouseDelta) {
        return this.brushWidget.renderAdjustment(mouseX, mouseY, mouseDelta);
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.biome_painter");
    }

    @Override
    public void writeSourceInfo(class_2487 tag, boolean includeSettings) {
        tag.method_10582("SourceName", "Biome Painter Tool");
        if (includeSettings) {
            class_2487 settings = new class_2487();
            this.writeSettings(settings);
            tag.method_10566("SourceSettings", (class_2520)settings);
        }
    }

    @Override
    public void writeSettings(class_2487 tag) {
        tag.method_10556("FillVertically", this.fillVertically);
    }

    @Override
    public void loadSettings(class_2487 tag) {
        this.fillVertically = tag.method_10577("FillVertically");
    }

    @Override
    public char iconChar() {
        return '\ue914';
    }

    @Override
    public String keybindId() {
        return "biome_painter";
    }

    private record BiomeWithIndex(String prettyName, int index) {
    }
}

